<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis geometrických bodů</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis geometrických bodů</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                          <xsl:for-each select="GeometryProject">
                            <table class="margin" cellpadding="2" width="90%">
                              <tbody>
                                <tr>
                                  <th align="right" lang="en">Projekt:&#xa0; </th>
                                  <td align="left" colspan="2">
                                    <xsl:value-of select="@name"/>
                                  </td>
                                </tr>
                                <tr>
                                  <th align="right" lang="en">Popis:&#xa0; </th>
                                  <td align="left" colspan="2">
                                    <xsl:value-of select="@description"/>
                                  </td>
                                </tr>
                                <tr>
                                  <th align="right" lang="en">Základní (Aktivní) trasa:</th>
                                  <td align="left" colspan="2">
                                    <xsl:value-of select="HorizontalAlignment/@name"/>
                                  </td>
                                </tr>
                                <tr>
                                  <th align="right" lang="en">Název souboru:&#xa0; </th>
                                  <td align="left" colspan="2">
                                    <xsl:value-of select="@file"/>
                                  </td>
                                </tr>
                                <tr>
                                  <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                  <td align="left" colspan="2">
                                    <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                  </td>
                                </tr>
                                <tr>
                                  <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                  <td align="left" style="font-size: 80%"> </td>
                                  <td align="right" lang="en" style="font-size: 80%">
                                    <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                    <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                    <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                    pokud není specifikováno jinak.
                                  </td>
                                </tr>
                              </tbody>
                            </table>
                            <hr/>

                            <xsl:for-each select="GeometryPoint">
                              <table cellspacing="4" width="100%">
                                <thead style="display:table-header-group">
                                  <tr>
                                    <th class="underline" lang="en" align="left">Bod</th>
                                    <th class="underline" lang="en" align="left">Prvek</th>
                                    <th class="underline" lang="en" align="left">Popis</th>
                                    <th class="underline" lang="en" align="left">Y<sub>s-jtsk</sub></th>
                                    <th class="underline" lang="en" align="left">X<sub>s-jtsk</sub></th>
                                    <th class="underline" lang="en" align="left">Z</th>
                                  </tr>
                                </thead>
                                <tbody>
                                  <xsl:for-each select="GeometryPointProperties">
                                    <tr>
                                      <td align="left">
                                        <xsl:value-of select="@PointName"/>
                                      </td>
                                      <td align="left">
                                        <xsl:value-of select="@FeatureName"/>
                                      </td>
                                      <td align="left">
                                        <xsl:value-of select="@PointDescription"/>
                                      </td>
                                      <td align="left">
                                        <xsl:value-of select="cif:ordinateFormat(number(@easting)*(-1))"/>
                                      </td>
                                      <td align="left">
                                        <xsl:value-of select="cif:ordinateFormat(number(@northing)*(-1))"/>
                                      </td>
                                      <td align="left">
                                        <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                                      </td>
                                    </tr>
                                  </xsl:for-each>
                                </tbody>
                              </table>
                            </xsl:for-each>
                          </xsl:for-each>

                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body v odstupu příkazem <em>
                    Nástroje &gt; XML Výpisy &gt; Staničení Odstup
                </em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení nebo prvek v záložce <em>Obecně</em>
                v poli <em>Z</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení v záložce<em>
                    Směrové řešení
                </em> nebo jeden prvek v záložce <em> Prvky</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v záložce <em>Zahrnout</em>(<em>
                    Na směrovém řešení-
                    Body trasy, Směrové významné body, Výškové významné body
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
